/************************************************************************
 * slc.h -- routines for reading the parameters to compiled shader files
 *          for the BMRT.
 *
 * The Blue Moon Rendering Tools (BMRT) are:
 * (c) Copyright 1990-2000 Exluna, Inc. and Larry Gritz. All rights reserved.
 *
 * $Revision: 1.12 $   $Date: 2000/11/14 01:11:21 $
 ************************************************************************/

#ifndef SLC_H
#define SLC_H
#define SO_H   /* old name */

#ifdef __cplusplus
extern "C" {
#endif


typedef enum {
    SLC_TYPE_UNKNOWN,
    SLC_TYPE_POINT,
    SLC_TYPE_COLOR,
    SLC_TYPE_SCALAR,
    SLC_TYPE_STRING,

    SLC_TYPE_SURFACE,
    SLC_TYPE_LIGHT,
    SLC_TYPE_DISPLACEMENT,
    SLC_TYPE_VOLUME,
    SLC_TYPE_TRANSFORMATION,
    SLC_TYPE_IMAGER,
    SLC_TYPE_VECTOR,
    SLC_TYPE_NORMAL,
    SLC_TYPE_MATRIX
    } SLC_TYPE;

typedef enum {
    SLC_STOR_UNKNOWN,
    SLC_STOR_CONSTANT,
    SLC_STOR_VARIABLE,
    SLC_STOR_TEMPORARY,
    SLC_STOR_PARAMETER,
    SLC_STOR_OUTPUTPARAMETER,
    SLC_STOR_GSTATE
    } SLC_STORAGE;

typedef enum {
    SLC_DETAIL_UNKNOWN,
    SLC_DETAIL_VARYING,
    SLC_DETAIL_UNIFORM
    } SLC_DETAIL;


typedef struct {
    float	xval;
    float	yval;
    float	zval;
    } SLC_POINT;


typedef float SLC_SCALAR;

#ifndef _WIN32
typedef float SCALAR;
typedef SLC_POINT POINT;
#endif



typedef struct SLCvissymdef {
    char *svd_name;
    SLC_TYPE svd_type;
    SLC_STORAGE svd_storage;
    SLC_DETAIL svd_detail;
    char *svd_spacename;
    union {
	SLC_POINT  *pointval;
	SLC_SCALAR *scalarval;
	SLC_SCALAR *matrixval;
	char	   *stringval;
    } svd_default;
    union SLCsvd_defaultvalu {
	SLC_POINT   svd_pointval;
	SLC_SCALAR  svd_scalarval;
	SLC_SCALAR  svd_matrixval[16];
    } svd_defaultval;
    unsigned svd_valisvalid : 1;
    int svd_arraylen;
} SLC_VISSYMDEF;



#define NULL_SLCVISSYMDEF ((SLC_VISSYMDEF *)0)


extern void SLC_SetPath (char *path);
extern char *SLC_GetPath (void);
extern int SLC_SetShader (char *name);
extern char *SLC_GetName (void);
extern SLC_TYPE SLC_GetType (void);
extern int SLC_GetNArgs (void);
extern SLC_VISSYMDEF *SLC_GetArgByName (char *name);
extern SLC_VISSYMDEF *SLC_GetArgById (int id);
extern SLC_VISSYMDEF *SLC_GetArrayArgElement (SLC_VISSYMDEF *array, int index);
extern void SLC_EndShader (void);
extern char *SLC_TypetoStr (SLC_TYPE type);
extern char *SLC_StortoStr (SLC_STORAGE storage);
extern char *SLC_DetailtoStr (SLC_DETAIL detail);
extern char *SLC_GetARCH (void);


#ifdef __cplusplus
}
#endif

#endif /* SLC_H */
